﻿"""
https://chatgpt.com/share/68f19ead-a010-8000-9fac-e73ab254fa94

Here is a spreadsheet (from 20251002 David Brodwin's presentation).
Three equity price histories are entered in columns B, E and H (labeled “EC”) for equites S398, SB029 and SB041 respectively.
Monthly return for each equity is calculated in columns C, F and I (labeled “Mo Return”) respectively.
Maximum Draw down is calculated in columns D, G and J (labeled “DD%”) respectively.
CAGR, Mean Return, Max Draw Down and MAR are saluted for each equity in rows 29,30,31 and 32 respectively.

The goal is to construct a “Composite Portfolio” with the “EC” in K, the “Mo return” in L and the “DD%” in M.

This spreadsheet is passed to Excel’s “Solver”.
With the Objective set to maximize $L$32 (The composite portfolio’s MAR) by changing the values in P2,Q2 and R2
subject to the constraints
$P$2 <=1
$Q$2 <=1
$R$2 <=1
$S$2 <=1
Using a GRG Nonlinear solver method.
This solver is used for problems that are smooth nonlinear.
Please provide a python program that does the same thing.
The program should be passed two argument:
a data frame containing dates in the first column, Equity names in the column headers, and equity price histories in the remaining columns.
Use whatever python optimizer package makes the most sense (CVXPY, PyPortfolioOpt or scipy.optimize.minimize)

Please regenerate after adding a "MaxDD" argument to optimize_mar_from_prices.  E.g. setting MaxDD to "10" will maximize CAGR subject to MaxDD<=10%
"""
"""
  for column in df.columns:
    if ";" in column:
      print(column.split(";")[0])
    else: print(column)
"""
# pip install numpy pandas scipy plotly kaleido
import pandas as pd
from mar_optimizer import optimize_mar_from_prices

def doit(df):
  # 1) Original behavior — maximize MAR, with per-strategy cap (e.g., 60%)
  res_mar = optimize_mar_from_prices(df, wmax=0.60, n_restarts=25)
  printit(df,res_mar, "maximize MAR, wmax=0.60")

  res_mar = optimize_mar_from_prices(df, wmax=0.99, n_restarts=25)
  printit(df,res_mar, "maximize MAR, wmax=0.99")

  # 2) New behavior — maximize CAGR subject to MaxDD <= 10%
  res_cagr_dd = optimize_mar_from_prices(df, wmax=0.60, n_restarts=25, MaxDD=10)
  printit(df,res_cagr_dd, "maximize CAGR subject to MaxDD <= 10%, wmax=0.60")

  # 3) New behavior — maximize CAGR subject to MaxDD <= 10%
  res_cagr_dd = optimize_mar_from_prices(df, wmax=0.99, n_restarts=25, MaxDD=10)
  printit(df,res_cagr_dd, "maximize CAGR subject to MaxDD <= 10%, wmax=0.99")
  #=========================
  # Notes:
  # - You can pass MaxDD as 10 (percent) or 0.10 (decimal). Both mean 10%.
  # - Constraints enforced: 0 <= w_i <= wmax, sum(w_i) == 1 (no leverage).
  # - Solver: SLSQP with multi-starts; objective switches based on MaxDD being set.

def printit(df,result, title):
  print("\n\n",title)
  print("Optimal weights (match columns in your DataFrame after the date column):")
  print(result.weights)
  print(f"CAGR: {result.cagr:.2%}")
  print(f"Mean Return (per period): {result.mean_return:.4f}")
  print(f"Max Drawdown: {result.max_drawdown:.2%}")
  print(f"MAR (CAGR / MaxDD): {result.mar:.3f}")

  # The composite time series (like your K/L/M columns in Excel):
  comp_curve = result.composite_curve          # equity curve (EC)
  comp_returns = result.composite_returns      # monthly returns (Mo Return)

  # If you want the drawdown series too:
  # from mar_optimizer import _drawdown_stats
  # _, dd_series, _ = _drawdown_stats(comp_returns)

  from mar_optimizer import _drawdown_stats,_price_df_to_returns
  ec, dd_series, _ = _drawdown_stats(comp_returns)
  rdf=_price_df_to_returns(df)
  ys=["comp_ec"]
  for columnName in rdf.columns:
    y=columnName+"_ec"
    ys.append(y)
    rdf[y]=(1 + rdf[columnName]).cumprod()
  rdf["Date"]=rdf.index
  rdf["comp_ec"]=ec
  rdf["comp_returns"]=comp_returns
  rdf["comp_drawdown"]=dd_series
  print(rdf)
  import plotly.express as px
  fig = px.line(rdf, x='Date', y=ys, title=title)
  fig.write_image(title+".jpeg")
  #fig.show()

# S  2025 > 250829 > Strats0  > Final > 20250830.1450_ECs_20240611_Strats0-all-mar_19941230-20250829.xlsx
# SB 2025 > 250829 > Strats7  > Final > 20250830.1450_ECs_20240611_Strats7-all-mar_19941230-20250829.xlsx
# SD 2025 > 250829 > Strats9  > Final > 20250830.1440_ECs_20241231_Strats9-all-mar_19941230-20250829.xlsx
# SE 2025 > 250829 > Strats10 > Final > 20250830.1427_ECs_20241231_Strats10-all-mar_19941230-20250829.xlsx
import glob  
def get_column(stratName,dfs):
  for df in dfs:
    for columnName in df.columns:
      if stratName in columnName:
        return df[columnName]

def createDF(stratNames,begDate,endDate,path="Strats/*.xlsx"):
  dfs= [pd.read_excel(filename,index_col=0) for filename in glob.glob(path)]
  dfs.reverse() # Put Strats0 last.
  df=pd.DataFrame()
  for stratName in stratNames:
    column=get_column(stratName,dfs)
    df[stratName]= column[begDate:endDate]
  return df

def main():
  df=createDF(['S398','SB029','SB041'],"2022-12-30","2024-12-31")
  print(df)
  #df = pd.read_csv("20251016 Example - Blending Strategies Data.csv", parse_dates=[0], index_col=0,sep="\t")  # wgp
  doit(df)

main()


