"""
https://chatgpt.com/share/68f19ead-a010-8000-9fac-e73ab254fa94
Here is a spreadsheet (from 20251002 David Brodwin's presentation).
Three equity price histories are entered in columns B, E and H (labeled “EC”) for equites S398, SB029 and SB041 respectively.
Monthly return for each equity is calculated in columns C, F and I (labeled “Mo Return”) respectively.
Maximum Draw down is calculated in columns D, G and J (labeled “DD%”) respectively.
CAGR, Mean Return, Max Draw Down and MAR are saluted for each equity in rows 29,30,31 and 32 respectively.

The goal is to construct a “Composite Portfolio” with the “EC” in K, the “Mo return” in L and the “DD%” in M.

This spreadsheet is passed to Excel’s “Solver”.
With the Objective set to maximize $L$32 (The composite portfolio’s MAR) by changing the values in P2,Q2 and R2
subject to the constraints
$P$2 <=1
$Q$2 <=1
$R$2 <=1
$S$2 <=1
Using a GRG Nonlinear solver method.
This solver is used for problems that are smooth nonlinear.
Please provide a python program that does the same thing.
The program should be passed a data frame containing dates in the first column, Equity names in the column headers, and equity price histories in the remaining columns.
Use whatever python optimizer package makes the most sense (CVXPY, PyPortfolioOpt or scipy.optimize.minimize)
"""
# pip install numpy pandas scipy
import pandas as pd
from mar_optimizer import optimize_mar_from_prices

# 1) Load your prices: first column = dates, remaining columns = price histories
#wgp df = pd.read_excel("your_prices.xlsx")  # or pd.read_csv(...)
df = pd.read_csv("20251016 Example - Blending Strategies Data.csv", parse_dates=[0], index_col=0,sep="\t")  # wgp
#print(df)

# 2) Run optimization (cap each strategy at, say, 60%)
result = optimize_mar_from_prices(df, wmax=0.60, n_restarts=25)

print("Optimal weights (match columns in your DataFrame after the date column):")
print(result.weights)

print(f"CAGR: {result.cagr:.2%}")
print(f"Mean Return (per period): {result.mean_return:.4f}")
print(f"Max Drawdown: {result.max_drawdown:.2%}")
print(f"MAR (CAGR / MaxDD): {result.mar:.3f}")

# The composite time series (like your K/L/M columns in Excel):
comp_curve = result.composite_curve          # equity curve (EC)
comp_returns = result.composite_returns      # monthly returns (Mo Return)

# If you want the drawdown series too:
# from mar_optimizer import _drawdown_stats
# _, dd_series, _ = _drawdown_stats(comp_returns)
#wgp
from mar_optimizer import _drawdown_stats,_price_df_to_returns
ec, dd_series, _ = _drawdown_stats(comp_returns)
rdf=_price_df_to_returns(df)
rdf["comp_ec"]=ec
rdf["comp_returns"]=comp_returns
rdf["comp_drawdown"]=dd_series
print(rdf)
import plotly.express as px
rdf["Date"]=rdf.index
rdf["S398_ec"]=(1 + rdf['S398']).cumprod()
rdf["SB029_ec"]=(1 + rdf['SB029']).cumprod()
rdf["SB041_ec"]=(1 + rdf['SB041']).cumprod()
fig = px.line(rdf, x='Date', y=['S398_ec', 'SB029_ec', 'SB041_ec', 'comp_ec'], title='Values Over Time')
fig.show()
